<?php
header('Content-Type: application/json');
require_once 'process_data.php';
require_once 'generate_pdf.php';
require_once 'send_email.php';

// Receive data
$data = json_decode(file_get_contents('php://input'), true);

// Validate data
if (!validateInvoiceData($data)) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid data received']);
    exit;
}

// Process data
$processedData = processInvoiceData($data);

// Generate PDF
$pdfPath = generatePDF($processedData);

// Send email
$emailResult = sendInvoiceEmail($pdfPath, $data['invoice_number']);

echo json_encode(['success' => true, 'message' => 'PDF generated and sent']);
