<?php
namespace App;

use GuzzleHttp\Client;

class ZohoService {
    private $client;
    private $config;

    public function __construct($config) {
        $this->config = $config;
        $this->client = new Client([
            'base_uri' => $config['zoho']['api_domain'],
            'headers' => [
                'Authorization' => 'Bearer ' . $config['zoho']['access_token'],
                'Content-Type' => 'application/json',
            ]
        ]);
    }

    public function getInvoice($invoiceId) {
        $response = $this->client->get("/invoices/{$invoiceId}", [
            'query' => [
                'organization_id' => $this->config['zoho']['organization_id']
            ]
        ]);

        return json_decode($response->getBody()->getContents(), true);
    }
}
