<?php
require_once('tcpdf/tcpdf.php');
require_once('templates/invoice_template.php');

function generatePDF($data) {
    $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    
    // Set document information
    $pdf->SetCreator('Your Company');
    $pdf->SetAuthor('Your Company');
    $pdf->SetTitle('Invoice ' . $data['invoice_number']);
    
    // Add a page
    $pdf->AddPage();
    
    // Get HTML content from template
    $html = getInvoiceTemplate($data);
    
    // Write HTML content
    $pdf->writeHTML($html, true, false, true, false, '');
    
    // Save PDF
    $pdfPath = 'temp/pdf/invoice_' . $data['invoice_number'] . '.pdf';
    $pdf->Output($pdfPath, 'F');
    
    return $pdfPath;
}
