<?php
function getInvoiceTemplate($data) {
    return <<<HTML
    <!DOCTYPE html>
    <html>
    <head>
        <link rel="stylesheet" href="../assets/css/invoice.css">
    </head>
    <body>
        <div class="invoice-header">
            <img src="../assets/images/logo.png" class="logo">
            <h1>INVOICE</h1>
        </div>
        <div class="customer-info">
            <p>Customer: {$data['customer']}</p>
            <p>Invoice Number: {$data['invoice_number']}</p>
            <p>Date: {$data['date']}</p>
        </div>
        <table class="items-table">
            <tr>
                <th>Item</th>
                <th>Quantity</th>
                <th>Price</th>
                <th>Total</th>
            </tr>
            <!-- Items will be inserted here dynamically -->
        </table>
        <div class="total-section">
            <p>Total: {$data['total']}</p>
        </div>
    </body>
    </html>
    HTML;
}
